//
//  ListOfPictureViewController.swift
//  BackAnimation
//
//  Created by 9Brainz on 14/12/18.
//  Copyright © 2018 9Brainz. All rights reserved.
//

import UIKit

class ListOfPictureViewController: UIViewController,UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout
{

    let arrPicture = ["img1","img2","img3","img4","img5","img6","img7","img8","img9","img10"]
 
    @IBOutlet weak var cvPictures: UICollectionView!
    
    override func viewDidLoad()
    {
        super.viewDidLoad()
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return arrPicture.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell
    {
        let cell : ListOfPictureCollectionViewCell = collectionView.dequeueReusableCell(withReuseIdentifier: "ListOfPictureCollectionViewCell", for: indexPath as IndexPath) as! ListOfPictureCollectionViewCell
        cell.imgPictures.image = UIImage(named: "\(arrPicture[indexPath.row])")
        cell.lblName.text = arrPicture[indexPath.row]
        return cell
        
    }
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath)
    {
        let objDisplay : DisplayDetailsViewController = self.storyboard?.instantiateViewController(withIdentifier: "DisplayDetailsViewController") as! DisplayDetailsViewController
        objDisplay.arrCollection = self.arrPicture
        objDisplay.strSelcted = "\(arrPicture[indexPath.item])"
        self.navigationController?.pushViewController(objDisplay, animated: true)

    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize
    {
        var witdhOfCell = CGFloat()
        var heightOfCell = CGFloat()
        let imgSize = UIImage(named: "\(arrPicture[indexPath.row])")?.size
        if Float((imgSize?.width)!) > Float((imgSize?.height)!)
        {
            witdhOfCell = (SCREEN_WIDTH / 2) - 16
            heightOfCell = (SCREEN_WIDTH * 80) / 165
        }
        else
        {
        
            witdhOfCell = (SCREEN_WIDTH / 2) - 16
            heightOfCell = (SCREEN_WIDTH * 80) / 120
        }
        return CGSize(width: witdhOfCell, height: heightOfCell)
    }
}


